<div class="col-lg-3">

 <!-- Featured Profile Package -->
 <?php 
    $featured_package = App\Package::where('package_for', 'make_featured')->first();
    $packageEndDate = auth()->user()->featured_package_end_at ?? auth()->user()->package_end_date;
    $isExpired = $packageEndDate ? \Carbon\Carbon::parse($packageEndDate)->isPast() : true;
?>

<?php if(!auth()->user()->is_featured || $isExpired): ?>
    <div class="featuredprofile">
        <div class="packginfor">
            <h5><i class="fas fa-bolt"></i> <?php echo e($featured_package->package_title); ?></h5>
            <div class="featprice"><?php echo e($siteSetting->default_currency_code ?? ''); ?><?php echo e($featured_package->package_price); ?><span>For <?php echo e($featured_package->package_num_days); ?> <?php echo e(__('Days')); ?></span></div>
            <p>Gain a competitive edge in the job market with exclusive features</p>
            <ul class="pckfeatlist">
                <li><i class="fas fa-crown"></i> Premium Badge</li>
                <li><i class="fas fa-chart-line"></i> Rank Booster</li>
                <li><i class="fas fa-ribbon"></i> Your CV above all others</li>
                <li><i class="fas fa-briefcase"></i> Increased Job Opportunities</li>
                <li><i class="fas fa-eye"></i> Higher Profile Views</li>
                <li><i class="fas fa-bell"></i> Exclusive Alerts</li>
            </ul>
        </div>
        <div class="order">
            <?php if(count(auth()->user()->getProfileProjectsArray()) == 0 || count(auth()->user()->getProfileCvsArray()) == 0 || count(auth()->user()->profileExperience()->get()) == 0 || count(auth()->user()->profileEducation()->get()) == 0 || count(auth()->user()->profileSkills()->get()) == 0): ?>				
                <a href="javascript:void();" data-bs-toggle="modal" data-bs-target="#buyfeatured">Buy Now</a>
            <?php else: ?>
                <a href="<?php echo e(route('order.package', $featured_package->id)); ?>"> 
                    <i class="fab fa-cc-paypal" aria-hidden="true"></i> <?php echo e(__('PayPal')); ?>

                </a>
                <a href="<?php echo e(route('stripe.order.form', [$featured_package->id, 'new'])); ?>" class="mt-3">
                    <i class="fab fa-cc-stripe" aria-hidden="true"></i> <?php echo e(__('Stripe')); ?>

                </a>
            <?php endif; ?>
        </div>
    </div>
<?php else: ?>
    <div class="featuredprofile purchased">
        <div class="packginfor">
            <h5>Featured Profile</h5>
            <p>Congratulations! Your profile is now prominently displayed to attract more attention from recruiters and employers.</p>
        </div>
        <ul class="pckfeatlist">
            <li><i class="fas fa-crown"></i> Premium Badge</li>
            <li><i class="fas fa-chart-line"></i> Rank Booster</li>
            <li><i class="fas fa-ribbon"></i> Your CV above all others</li>
            <li><i class="fas fa-briefcase"></i> Increased Job Opportunities</li>
            <li><i class="fas fa-eye"></i> Higher Profile Views</li>
            <li><i class="fas fa-bell"></i> Exclusive Alerts</li>
        </ul>
        <div class="">
            <div class="order">
                <span>Package Start On</span> 
                <strong><?php echo e(\Carbon\Carbon::parse(auth()->user()->package_start_date)->format('d M Y')); ?></strong>
            </div>
            <div class="order">
                <span>Package Ends On</span> 
                <strong><?php echo e(\Carbon\Carbon::parse($packageEndDate)->format('d M Y')); ?></strong>
            </div>
        </div>
    </div>
<?php endif; ?>

            <!-- Modal -->
            <div class="modal fade mypremodal" id="buyfeatured" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="modal-body">
                        <div class="preuserinfo">
                        <h3>To Buy Featured Package you need to first complete your profile.</h3>
                        <a href="<?php echo e(route('my.profile')); ?>" class="btn btn-yellow mt-3">Edit Profile</a>
                        </div>
                    </div>
                    </div>
                </div>
            </div>




	<div class="usernavwrap">
    <div class="switchbox">
        <div class="txtlbl"><?php echo e(__('Open to Work')); ?> <i class="fas fa-question-circle" title="<?php echo e(__('Are you immediate available')); ?>?"></i>
        </div> 
        <div class="">
            <label class="switch switch-green"> <?php
                $checked = ((bool)Auth::user()->is_immediate_available)? 'checked="checked"':'';
                ?>
                <input type="checkbox" name="is_immediate_available" id="is_immediate_available" class="switch-input" <?php echo e($checked); ?> onchange="changeImmediateAvailableStatus(<?php echo e(Auth::user()->id); ?>, <?php echo e(Auth::user()->is_immediate_available); ?>);">
                <span class="switch-label" data-on="Yes" data-off="No"></span> <span class="switch-handle"></span> </label>
        </div>
        <div class="clearfix"></div>
    </div>
    <ul class="usernavdash">
        <li class="<?php echo e(Request::url() == route('home') ? 'active' : ''); ?>"><a href="<?php echo e(route('home')); ?>"><i class="fas fa-tachometer" aria-hidden="true"></i> <?php echo e(__('Dashboard')); ?></a>
        </li>
        <li class="<?php echo e(Request::url() == route('my.profile') ? 'active' : ''); ?>"><a href="<?php echo e(route('my.profile')); ?>"><i class="fas fa-pencil" aria-hidden="true"></i> <?php echo e(__('Edit Profile')); ?></a>
        </li>
        <li class="<?php echo e(Request::url() == route('build.resume') ? 'active' : ''); ?>"><a href="<?php echo e(route('build.resume')); ?>"><i class="fas fa-file" aria-hidden="true"></i> <?php echo e(__('Build Resume')); ?></a></li>
        <li><a href="<?php echo e(route('resume', Auth::user()->id)); ?>"><i class="fa fa-print" aria-hidden="true"></i> <?php echo e(__('Download CV')); ?></a></li>
        <li><a href="<?php echo e(route('view.public.profile', Auth::user()->id)); ?>"><i class="fas fa-eye" aria-hidden="true"></i> <?php echo e(__('View Public Profile')); ?></a>
        </li>
        <li class="<?php echo e(Request::url() == route('my.job.applications') ? 'active' : ''); ?>"><a href="<?php echo e(route('my.job.applications')); ?>"><i class="fas fa-desktop" aria-hidden="true"></i> <?php echo e(__('My Job Applications')); ?></a>
        </li>
        <li class="<?php echo e(Request::url() == route('my.favourite.jobs') ? 'active' : ''); ?>"><a href="<?php echo e(route('my.favourite.jobs')); ?>"><i class="fas fa-heart" aria-hidden="true"></i> <?php echo e(__('My Favourite Jobs')); ?></a>
        </li>
        <li class="<?php echo e(Request::url() == route('my-alerts') ? 'active' : ''); ?>"><a href="<?php echo e(route('my-alerts')); ?>"><i class="fas fa-bullhorn" aria-hidden="true"></i> <?php echo e(__('My Job Alerts')); ?></a>
        </li>

        <li class="<?php echo e(Request::url() == route('candidate.list-payment-history') ? 'active' : ''); ?>">
        <a href="<?php echo e(route('candidate.list-payment-history')); ?>"><i class="fas fa-file-invoice-dollar"></i> <?php echo e(__('Payment History')); ?></a>
        </li>


        <li><a href="<?php echo e(url('my-profile#cvs')); ?>"><i class="fas fa-file" aria-hidden="true"></i> <?php echo e(__('Manage Resume')); ?></a>
        </li>
        <li class="<?php echo e(Request::url() == route('my.messages') ? 'active' : ''); ?>"><a href="<?php echo e(route('my.messages')); ?>"><i class="fas fa-envelope" aria-hidden="true"></i> <?php echo e(__('My Messages')); ?></a>
        </li>
        <li class="<?php echo e(Request::url() == route('my.followings') ? 'active' : ''); ?>"><a href="<?php echo e(route('my.followings')); ?>"><i class="fas fa-user" aria-hidden="true"></i> <?php echo e(__('My Followings')); ?></a>
        </li>
        <li><a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><i class="fas fa-sign-out" aria-hidden="true"></i> <?php echo e(__('Logout')); ?></a>
            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                <?php echo e(csrf_field()); ?>

            </form>
        </li>
    </ul>
		</div>
   
		
</div><?php /**PATH D:\xampp8\htdocs\jobsportal\resources\views/includes/user_dashboard_menu.blade.php ENDPATH**/ ?>